<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Receptor de udio</title>
</head>
<body>
    <h1>ID do Receptor: <span id="peerIdSpan"></span></h1>
    <audio id="remoteAudio" controls autoplay></audio>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/peerjs/1.3.2/peerjs.min.js"></script>
    <script>
        const remoteAudio = document.getElementById('remoteAudio');
        const peerIdSpan = document.getElementById('peerIdSpan');
        
        // Configurar as opes do servidor PeerJS
        const peerOptions = {
            host: 'peerjs-server.herokuapp.com',
            secure: true,
            port: 443,
            debug: 3 // Ajuste o nvel de debug para ver mais detalhes
        };
        
        // Criar uma nova instncia do Peer
        const peer = new Peer(undefined, peerOptions);

        peer.on('open', function(id) {
            console.log('Receptor: ID do Peer  ' + id);
            peerIdSpan.textContent = id;
            listenForCalls(id); // Aguardar chamadas de transmisso
        });
        peer.on('error', function(error) {
            console.error('Erro no Peer:', error);
        });

        function listenForCalls(peerId) {
            peer.on('call', function(call) {
                console.log('Chamada recebida do transmissor');
                navigator.mediaDevices.getUserMedia({ video: false, audio: true })
                    .then(function(stream) {
                        remoteAudio.srcObject = stream;
                        call.answer(stream);
                    })
                    .catch(function(err) {
                        console.error('Erro ao obter o stream local', err);
                    });
            });
        }
    </script>
</body>
</html>
