const localVideo = document.getElementById('localVideo');
const remoteVideo = document.getElementById('remoteVideo');
const connectButton = document.getElementById('connectButton');
const remotePeerIdInput = document.getElementById('remotePeerId');

let peer = new Peer();

peer.on('open', function(id) {
    console.log('My peer ID is: ' + id);
});

connectButton.onclick = function() {
    const remotePeerId = remotePeerIdInput.value;

    navigator.mediaDevices.getUserMedia({ video: true, audio: true })
        .then(function(stream) {
            localVideo.srcObject = stream;

            const call = peer.call(remotePeerId, stream);
            call.on('stream', function(remoteStream) {
                remoteVideo.srcObject = remoteStream;
            });
        })
        .catch(function(err) {
            console.error('Failed to get local stream', err);
        });
};

peer.on('call', function(call) {
    navigator.mediaDevices.getUserMedia({ video: true, audio: true })
        .then(function(stream) {
            call.answer(stream);
            call.on('stream', function(remoteStream) {
                remoteVideo.srcObject = remoteStream;
            });
        })
        .catch(function(err) {
            console.error('Failed to get local stream', err);
        });
});
