<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Transmissor de udio</title>
</head>
<body>
    <h1>ID do Transmissor: <span id="peerIdSpan"></span></h1>
    <video id="localVideo" autoplay muted></video>
    <button id="startButton">Iniciar Transmisso</button>
    <button id="stopButton">Parar Transmisso</button>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/peerjs/1.3.2/peerjs.min.js"></script>
    <script>
        const peerIdSpan = document.getElementById('peerIdSpan');
        const localVideo = document.getElementById('localVideo');
        const startButton = document.getElementById('startButton');
        const stopButton = document.getElementById('stopButton');
        let localStream;
        let peer;

        startButton.onclick = async function() {
            try {
                localStream = await navigator.mediaDevices.getUserMedia({ video: true, audio: true });
                localVideo.srcObject = localStream;
                startButton.disabled = true;
                stopButton.disabled = false;

                // Configurar as opes do servidor PeerJS
                const peerOptions = {
                    host: 'peerjs-server.herokuapp.com',
                    secure: true,
                    port: 443,
                    debug: 3 // Ajuste o nvel de debug para ver mais detalhes
                };

                // Iniciar a conexo Peer
                peer = new Peer(undefined, peerOptions);
                peer.on('open', function(id) {
                    console.log('Transmissor: ID do Peer  ' + id);
                    peerIdSpan.textContent = id;
                    discoverPeers(id); // Buscar receptores disponveis
                });
                peer.on('error', function(error) {
                    console.error('Erro no Peer:', error);
                });
            } catch (error) {
                console.error('Erro ao acessar a cmera ou microfone:', error);
            }
        };

        stopButton.onclick = function() {
            if (localStream) {
                localStream.getTracks().forEach(track => track.stop());
                localVideo.srcObject = null;
                startButton.disabled = false;
                stopButton.disabled = true;
                if (peer) {
                    peer.disconnect();
                    peer.destroy();
                    peer = null;
                }
            }
        };

        function discoverPeers(peerId) {
            const peer = new Peer({ key: 'peerjs', host: 'peerjs-server.herokuapp.com', secure: true, port: 443 });
            peer.on('open', function(id) {
                console.log('Peer descoberto: ' + id);
                connectToPeer(id, peerId);
            });
            peer.on('error', function(error) {
                console.error('Erro ao descobrir pares:', error);
            });
        }

        function connectToPeer(peerId, transmitterId) {
            const conn = peer.connect(peerId);
            conn.on('open', function() {
                console.log('Conectado ao receptor:', peerId);
                conn.send(transmitterId); // Envia o ID do transmissor para o receptor
            });
            conn.on('error', function(error) {
                console.error('Erro na conexo com o receptor:', peerId, error);
            });
            const call = peer.call(peerId, localStream);
            call.on('close', function() {
                console.log('Conexo encerrada com o receptor:', peerId);
            });
        }
    </script>
</body>
</html>
