<?php
 
// Do not delete these lines
if (!empty($_SERVER['SCRIPT_FILENAME']) && 'comments.php' == basename($_SERVER['SCRIPT_FILENAME']))
	die ('Please do not load this page directly. Thanks!');
 
if ( post_password_required() ) : ?>
	<p class="nocomment"><?php esc_html_e('This post is password protected. Enter the password to view any comments.', 'express' ); ?></p>
	</div>
	<?php return;
endif;
?>
<?php if ( have_comments() ) : ?>
	<div class="widget-heading">
	 <h3>
		<?php printf( _n( 'Comment (%1$s) ', 'Comments (%1$s)', get_comments_number(), 'express' ),number_format_i18n( get_comments_number() ), '<em>' . get_the_title() . '</em>' );?>
	</h3>
	</div>
	<?php if ( get_comment_pages_count() > 1 && get_option( 'page_comments' ) ) : // Are there comments to navigate through? ?>
		<div class="navigation">
			<div class="nav-previous"><span class="meta-nav">&larr;</span> <?php previous_comments_link( esc_html__('Older Comments', 'express' ) ); ?></div>
			<div class="nav-next"><?php next_comments_link( esc_html__('Newer Comments', 'express') ); ?> <span class="meta-nav">&rarr;</span></div>
		</div> <!-- .navigation -->
	<?php endif; ?>
	<ul class="comment-tree">
		<?php wp_list_comments('callback=express_comment'); ?>
	</ul>
	<?php else : // this is displayed if there are no comments so far ?>
		<?php if ('open' == $post->comment_status) : ?>
			<!-- If comments are open, but there are no comments. -->
		<?php else : // comments are closed ?>
			<!-- If comments are closed. -->
			<p class="nocomments"><?php esc_html_e('Comments are closed.', 'express' ); ?></p>
		<?php endif; ?>
	<?php endif; ?>

		<?php if ('open' == $post->comment_status) : ?>
				<?php if ( get_option('comment_registration') && !$user_ID ) : ?>
					<p class="bottom20">
						<?php esc_html_e('You must be logged in to post a comment', 'express')?>. <a href="<?php echo get_option('siteurl'); ?>/wp-login.php?redirect_to=<?php echo urlencode(get_permalink()); ?>"><?php esc_html_e('Click here to login', 'express')?></a> 
					</p>
				<?php else : ?> 
					<form action="<?php echo get_option('siteurl'); ?>/wp-comments-post.php" method="post" class="comment-form row">
						<div class="widget-heading col-md-12">
							<h3><?php comment_form_title( esc_html__('Leave Your Comment ', 'express'), esc_html__('Leave a Reply to %s', 'express') ); ?></h3>
						</div>
						<div class="col-sm-12">
							<div class="cancel-comment-reply"><?php cancel_comment_reply_link(); ?></div>
						</div>
						<?php if ( $user_ID ) : ?>
							<div class="col-sm-12">
								<p class="com_logined_text">
									<?php esc_html_e('Logged in as', 'express')?> 
								<a href="<?php echo get_option('siteurl'); ?>/wp-admin/profile.php"><?php echo esc_attr($user_identity); ?></a>. 
								<a href="<?php echo wp_logout_url(get_permalink()); ?>" title="Log out of this account"><?php esc_html_e('Log out', 'express')?> &raquo;</a>
								</p>
							</div>
							<?php else : ?>
								<div class="form-group col-md-4">
									<label><?php esc_html_e('Name *', 'express')?></label>
									<input type="text" class="form-control" name="author" id="author" title="<?php esc_html_e('Name', 'express')?>" value="<?php echo esc_attr($comment_author); ?>"  <?php if ($req) echo "required"; ?> />
								</div>
								<div class="form-group col-md-4">
									<label><?php esc_html_e('Email *', 'express')?></label>
								<input type="email" class="form-control" name="email" id="email" title="<?php esc_html_e('Email', 'express')?>" value="<?php echo sanitize_email($comment_author_email); ?>"  <?php if ($req) echo "required"; ?> />
								</div>
								<div class="form-group col-md-4">
									<label><?php esc_html_e('Subject', 'express')?></label>
									<input type="text" name="subject" id="subject" class="form-control" title="<?php esc_html_e('Subject', 'express')?>" value="<?php echo isset($comment_author_subject) ? esc_attr($comment_author_subject) : '' ?>"  <?php if ($req) echo "aria-required='true'"; ?> />
								</div>
							<?php endif; ?>
							<div class="form-group col-md-12">
								<label><?php esc_html_e('Comment *', 'express')?></label>
								<textarea class="form-control" name="comment" rows="4"  title="<?php esc_html_e('Comment', 'express')?>" id="comment" required=""></textarea>
							</div>
							<input type="submit"  value="<?php esc_html_e('Post comment', 'express')?>">
							<?php comment_id_fields(); ?>
							<?php do_action('comment_form', $post->ID); ?>
							<div class="sep-line-bottom"></div>
					</form>
				<?php endif;  ?>
		<?php endif;  ?>
