<?php
$get_meta = get_post_custom($post->ID);
$hidetitles = weblusive_get_option('hide_titles');
$hidebreadcrumbs = weblusive_get_option('hide_breadcrumbs');
$title = get_the_title($post->ID);
$tagline = isset( $get_meta['_weblusive_tagline'][0]) ? $get_meta["_weblusive_tagline"][0] : '';
$alternativetitle = isset( $get_meta['_weblusive_altpagetitle'][0]) ? $get_meta["_weblusive_altpagetitle"][0] : '';
$hideheading = isset( $get_meta['_weblusive_hide_innerheading'][0]) ? $get_meta["_weblusive_hide_innerheading"][0] : '';
$term = get_term_by( 'slug', get_query_var( 'term' ), get_query_var( 'taxonomy' ) );
$bgimage=weblusive_get_option('innerheading_background_image');

$image_id = get_post_thumbnail_id($post->ID);  
$image_url = wp_get_attachment_image_src($image_id,'full');  
$image_url = $image_url[0];

$headimg=isset ($get_meta["_weblusive_cusimage"]) ? $get_meta["_weblusive_cusimage"][0] : '';
$bgimg = '';
if(isset($get_meta['_weblusive_post_head'][0]) && $get_meta['_weblusive_post_head'][0] == 'cusimg' && $headimg){
	$bgimg=$headimg;
}
elseif($image_url && is_page()){
	$bgimg=$image_url;
}
elseif(!$image_url && $bgimage) {
	$bgimg=$bgimage;
}else{
	$bgimg=get_template_directory_uri() .'/images/about-banner.jpg' ;
}
?><?php
if(isset( $get_meta['_weblusive_post_head'][0]) && $get_meta['_weblusive_post_head'][0] == 'slider' && !empty( $get_meta['_weblusive_post_slider'][0] ) ){
		
		$custom_slider_args = array( 'post_type' => 'themeplaza_slider', 'p' => $get_meta['_weblusive_post_slider'][0] );
		$custom_slider = new WP_Query( $custom_slider_args );
		
		while ( $custom_slider->have_posts() ) : $custom_slider->the_post();
			
			$custom = get_post_custom($post->ID);
			$slidertype = isset ($custom["_weblusive_slider_type"]) ? $custom["_weblusive_slider_type"][0] : '1';
			$sliderLoop = isset ($custom["_weblusive_slider_loop"]) ? stripslashes($custom["_weblusive_slider_loop"][0]) : 'true';
			$sliderAutoplay = isset ($custom["_weblusive_slider_autoplay"]) ? stripslashes($custom["_weblusive_slider_autoplay"][0]) : 'true';
			$sliderInterval = isset ($custom["_weblusive_slider_interval"]) ? stripslashes($custom["_weblusive_slider_interval"][0]) : '5000';
			$slider = isset ($custom["custom_slider"]) ? unserialize( $custom["custom_slider"][0]) : 'zoro';
			
			$number = count($slider);
				
		if( $slider ):?>
				<section id="slider_blocks">
					<div class="homeSlider photo-slider flex-slider flexslider">
						<ul class="slides">
							<?php $counter=0; foreach( $slider as $slide ): 
								
								$image =  wp_get_attachment_image_src( $slide['id'], 'full'); 
								$width = isset($image[1]) ? $image[1] : '';
								$height = isset($image[2]) ? $image[2] : '';
								
								$finalimage = empty($image) ? '' : $image[0];
								$content = empty($slide['caption']) ? '' : stripslashes($slide['caption']) ;
								$videoUrl= empty($slide['video']) ? '' : ($slide['video']) ;
								?>
								<li class="item">
									<?php if( !empty( $slide['link'] ) ):?><a href="<?php echo esc_url($slide['link'])?>"><?php endif?>
										<img src="<?php echo esc_url($finalimage) ?>" alt="" width="<?php echo $width?>" height="<?php echo $height?>" />
									<?php if( !empty( $slide['link'] ) ):?></a><?php endif?>
									<div class="carousel-caption">
											<?php echo htmlspecialchars_decode(do_shortcode($content)); ?>
									</div>
								</li>
								
							<?php $counter++; endforeach; ?>
						</ul>
					</div>
					<script type="text/javascript">
						jQuery(document).ready(function(){ 
							jQuery('.homeSlider').flexslider({
								animation: "slide",
								slideshowSpeed: <?php echo esc_attr($sliderInterval); ?>,
								animationLoop: <?php echo $sliderLoop; ?>,
								slideshow: <?php echo esc_attr($sliderAutoplay) ?>,
								controlNav: false,
								directionNav: true,
								prevText:'',
								nextText:''
							})
						});
					</script>
			</section>
		<?php else: ?>
			<section id="slider_blocks" class="empty_slider">
				<div class="col-md-12 text-center">
					<p class="label label-danger">
						<i class="fa fa-warning"></i>
						<?php esc_html_e('No slider items were found in the selected slider. Please make sure to create some via "Slider" section in your admin panel.', 'express');?>
					</p>
				</div>
			</section>
		<?php endif;?>
		
	<?php endwhile; ?>

<?php }else {?>
<?php if(!is_page_template('homepage-template.php')):?>
<?php if (!$hideheading ):?>
<div id="page-banner" class="page-banner  container-fluid no-padding" style="background: url(<?php echo esc_url($bgimg);?>) no-repeat center center / cover #000000;">
	<?php 
	if(isset( $get_meta['_weblusive_post_head'][0]) && $get_meta['_weblusive_post_head'][0] == 'vimeovideo'){
		$video = isset ($get_meta["_weblusive_vimeo"]) ? $get_meta["_weblusive_vimeo"][0] : '';
		?>
		<div class="row  phead">
				<div class="col-md-12">
					<div class="portfolio-media">
						<?php if($video):?>
							<div class="flex-video vimeo">
								<iframe src="http://player.vimeo.com/video/<?php echo esc_attr($video)?>" width="500" height="500" ></iframe>
							</div>
						<?php else: ?>
							<p class="label label-warning"><?php esc_html_e('Vimeo video chosen from post head options but no video ID provided. Please make sure to provide a video ID to display it.', 'express')?></p>
						<?php endif?>
					</div>
				</div>
		</div>
	<?php 
	}
	elseif(isset( $get_meta['_weblusive_post_head'][0]) && $get_meta['_weblusive_post_head'][0] == 'youtubevideo'){
		$video = $get_meta["_weblusive_youtube"][0];
		?>
		<div class="row  phead">
				<div class="col-md-12">
					<div class="portfolio-media">
						<div class="flex-video youtube">
							<?php if($video):?>
								<iframe src="http://www.youtube.com/embed/<?php echo esc_attr($video)?>" width="500" height="500" ></iframe>
							<?php else: ?>
								<p><?php esc_html_e('Youtube video was chosen from post head options but no video ID provided. Please make sure to provide a video ID  to display it.', 'express')?></p>
							<?php endif?>
						</div>
					</div>
				</div>
		</div>
	<?php 	} ?>
	<div class="row">
		<div class="banner-content">
			<?php if (!$hidetitles && !is_page_template('homepage-template.php')):?>
			<h3>
				<?php 
				if ($term){
					echo $term->name;									
				}else{
					echo ($alternativetitle == '') ?  $title : $alternativetitle; 
				}
				?>	
			</h3>
			<?php endif; ?>
			<?php if (!$hidebreadcrumbs && !is_page_template('homepage-template.php')):?>
				<?php if(class_exists('the_breadcrumb')){ $albc = new the_breadcrumb; } ?>
			<?php endif; ?>
		</div>
	</div>
</div>
<?php endif; ?>
<?php endif; ?>
<?php }?>