<?php

/**** WIDGETS AREA ****/

/* ***************************************************** 
 * Plugin Name: Express Social widget
 * Description: Display social links.
 * Version: 1.0
 * Author: Weblusive
 * Author URI: http://www.weblusive.com
 * ************************************************** */
class alc_social_widget extends WP_Widget {

	// Widget setup.
	public function __construct() {

		// Widget settings.
		$widget_ops = array(
			'classname' => 'widget_alc_social',
			'description' => esc_html__('Display social links', 'express')
		);

		// Widget control settings.
		$control_ops = array(
			'id_base' => 'alc-social-widget'
		);

		// Create the widget.
		parent::__construct('alc-social-widget', esc_html__('Express - Social links', 'express') , $widget_ops, $control_ops);
	}

	// Display the widget on the screen.
	public function widget($args, $instance) {
		extract($args);
		$title = apply_filters('widget_title', $instance['title']);
		
		$social_target = apply_filters('social_target', $instance['social_target']);
		//$social_size = apply_filters('social_size', $instance['social_size']);
		// $social_placement = apply_filters('social_placement', $instance['social_placement']);
		
		$bitbucket = apply_filters('bitbucket', $instance['bitbucket']);
		$dribbble = apply_filters('dribbble', $instance['dribbble']);
		$facebook = apply_filters('facebook', $instance['facebook']);
		$flickr = apply_filters('flickr', $instance['flickr']);
		$github = apply_filters('github', $instance['github']);
		$google = apply_filters('google', $instance['google']);
		$instagram = apply_filters('instagram', $instance['instagram']);
		$linkedin = apply_filters('linkedin', $instance['linkedin']);
		$pinterest = apply_filters('pinterest', $instance['pinterest']);
		$skype = apply_filters('skype', $instance['skype']);
		$twitter = apply_filters('twitter', $instance['twitter']);
		$youtube = apply_filters('youtube', $instance['youtube']);
		
		echo $before_widget;
		if ($title) echo $before_title . $title . $after_title;
		
		$socials = array(
			'bitbucket' => $bitbucket, 
			'dribbble' => $dribbble, 
			'facebook' => $facebook, 
			'flickr' => $flickr, 
			'github' => $github, 
			'google-plus' => $google, 
			'instagram' => $instagram, 
			'linkedin' => $linkedin, 
			'pinterest' => $pinterest, 
			'skype' => $skype, 
			'twitter' => $twitter, 
			'youtube' => $youtube
		);
		$social_target = ($social_target === '0') ? '' : ' target="_blank"';
		$fullmarkup = array();
		foreach ($socials as $name => $link)
		{
			if ($link !== '')
			{
				$fullmarkup[] = '<li><a href="'.$link.'" '.$social_target.'  title="'.ucfirst($name).'"><i class="fa fa-'.$name.'"></i></a></li>';
			}
		}
		echo '<ul class="social-widget ">'.implode( "\n", $fullmarkup ).'</ul>'.$after_widget;
		
	}

	public function update($new_instance, $old_instance) {
		$instance = $old_instance;
		$instance['title'] = strip_tags($new_instance['title']);
		$instance['social_target'] = strip_tags($new_instance['social_target']);
	//	$instance['social_placement'] = strip_tags($new_instance['social_placement']);
	//	$instance['social_size'] = strip_tags($new_instance['social_size']);
		$instance['bitbucket'] = strip_tags($new_instance['bitbucket']);
		$instance['dribbble'] = strip_tags($new_instance['dribbble']);
		$instance['facebook'] = strip_tags($new_instance['facebook']);
		$instance['flickr'] = strip_tags($new_instance['flickr']);
		$instance['github'] = strip_tags($new_instance['github']);
		$instance['google'] = strip_tags($new_instance['google']);
		$instance['instagram'] = strip_tags($new_instance['instagram']);
		$instance['linkedin'] = strip_tags($new_instance['linkedin']);
		$instance['pinterest'] = strip_tags($new_instance['pinterest']);
		$instance['skype'] = strip_tags($new_instance['skype']);
		$instance['twitter'] = strip_tags($new_instance['twitter']);
		$instance['youtube'] = strip_tags($new_instance['youtube']);
		return $instance;
	}

	public function form($instance) {
		$defaults = array(
		'title' => 'Social links',
		'social_target' => '',
	//	'social_placement' => 'top-social',
	//	'social_size' => '',
		'bitbucket' => '',
		'dribbble' => '',
		'facebook' => '',
		'flickr' => '',
		'github' => '',
		'google' => '',
		'instagram' => '',
		'linkedin' => '',
		'pinterest' => '',
		'skype' => '',
		'twitter' => '',
		'youtube' => '',
		);
		
		$instance = wp_parse_args((array)$instance, $defaults); ?>
		<p>
			<label for="<?php echo $this->get_field_id('title'); ?>"><?php esc_html_e('Title:', 'express'); ?></label>
			<input id="<?php echo $this->get_field_id('title'); ?>" type="text" name="<?php echo $this->get_field_name('title'); ?>" value="<?php echo $instance['title']; ?>" class="widefat" />
		</p>
		<p>
			<label for="<?php echo $this->get_field_id('social_target'); ?>"><?php esc_html_e('Target window:', 'express'); ?></label>
			<select id="<?php echo $this->get_field_id('social_target'); ?>" name="<?php echo $this->get_field_name('social_target'); ?>" class="widefat">
				<option value="0" <?php if( $instance['social_target'] == 0):?>selected="selected"<?php endif?>><?php esc_html_e('Same window:', 'express'); ?></option> 
				<option value="1" <?php if( $instance['social_target'] == 1):?>selected="selected"<?php endif?>><?php esc_html_e('New window:', 'express'); ?></option> 
			</select>
		</p>
		<p>
			<label for="<?php echo $this->get_field_id('bitbucket'); ?>"><?php esc_html_e('Bitbucket:', 'express'); ?></label> 
			<input id="<?php echo $this->get_field_id('bitbucket'); ?>" type="text" name="<?php echo $this->get_field_name('bitbucket'); ?>" value="<?php echo $instance['bitbucket']; ?>" class="widefat" />
    	</p>
		<p>
			<label for="<?php echo $this->get_field_id('dribbble'); ?>"><?php esc_html_e('Dribble:', 'express'); ?></label> 
			<input id="<?php echo $this->get_field_id('dribbble'); ?>" type="text" name="<?php echo $this->get_field_name('dribbble'); ?>" value="<?php echo $instance['dribbble']; ?>" class="widefat" />
    	</p>
		<p>
			<label for="<?php echo $this->get_field_id('facebook'); ?>"><?php esc_html_e('Facebook:', 'express'); ?></label> 
			<input id="<?php echo $this->get_field_id('facebook'); ?>" type="text" name="<?php echo $this->get_field_name('facebook'); ?>" value="<?php echo $instance['facebook']; ?>" class="widefat" />
    	</p>
		<p>
			<label for="<?php echo $this->get_field_id('flickr'); ?>"><?php esc_html_e('Flickr:', 'express'); ?></label> 
			<input id="<?php echo $this->get_field_id('flickr'); ?>" type="text" name="<?php echo $this->get_field_name('flickr'); ?>" value="<?php echo $instance['flickr']; ?>" class="widefat" />
    	</p>
		<p>
			<label for="<?php echo $this->get_field_id('github'); ?>"><?php esc_html_e('Github:', 'express'); ?></label> 
			<input id="<?php echo $this->get_field_id('github'); ?>" type="text" name="<?php echo $this->get_field_name('github'); ?>" value="<?php echo $instance['github']; ?>" class="widefat" />
    	</p>
		<p>
			<label for="<?php echo $this->get_field_id('google'); ?>"><?php esc_html_e('Google+:', 'express'); ?></label> 
			<input id="<?php echo $this->get_field_id('google'); ?>" type="text" name="<?php echo $this->get_field_name('google'); ?>" value="<?php echo $instance['google']; ?>" class="widefat" />
    	</p>
		<p>
			<label for="<?php echo $this->get_field_id('instagram'); ?>"><?php esc_html_e('Instagram:', 'express'); ?></label> 
			<input id="<?php echo $this->get_field_id('instagram'); ?>" type="text" name="<?php echo $this->get_field_name('instagram'); ?>" value="<?php echo $instance['instagram']; ?>" class="widefat" />
    	</p>
		<p>
			<label for="<?php echo $this->get_field_id('linkedin'); ?>"><?php esc_html_e('LinkedIn:', 'express'); ?></label> 
			<input id="<?php echo $this->get_field_id('linkedin'); ?>" type="text" name="<?php echo $this->get_field_name('linkedin'); ?>" value="<?php echo $instance['linkedin']; ?>" class="widefat" />
    	</p>
		<p>
			<label for="<?php echo $this->get_field_id('pinterest'); ?>"><?php esc_html_e('Pinterest:', 'express'); ?></label> 
			<input id="<?php echo $this->get_field_id('pinterest'); ?>" type="text" name="<?php echo $this->get_field_name('pinterest'); ?>" value="<?php echo $instance['pinterest']; ?>" class="widefat" />
    	</p>
		<p>
			<label for="<?php echo $this->get_field_id('skype'); ?>"><?php esc_html_e('Skype:', 'express'); ?></label> 
			<input id="<?php echo $this->get_field_id('skype'); ?>" type="text" name="<?php echo $this->get_field_name('skype'); ?>" value="<?php echo $instance['skype']; ?>" class="widefat" />
    	</p>
		<p>
			<label for="<?php echo $this->get_field_id('twitter'); ?>"><?php esc_html_e('Twitter:', 'express'); ?></label> 
			<input id="<?php echo $this->get_field_id('twitter'); ?>" type="text" name="<?php echo $this->get_field_name('twitter'); ?>" value="<?php echo $instance['twitter']; ?>" class="widefat" />
    	</p>
		<p>
			<label for="<?php echo $this->get_field_id('youtube'); ?>"><?php esc_html_e('Youtube:', 'express'); ?></label> 
			<input id="<?php echo $this->get_field_id('youtube'); ?>" type="text" name="<?php echo $this->get_field_name('youtube'); ?>" value="<?php echo $instance['youtube']; ?>" class="widefat" />
    	</p>
	<?php
	}
}

register_widget('alc_social_widget');


/* ***************************************************** 
 * Plugin Name: Express Flickr
 * Description: Retrieve and display photos from Flickr.
 * Version: 1.0
 * Author: Weblusive
 * Author URI: http://www.weblusive.com
 * ************************************************** */
class alc_flickr_widget extends WP_Widget {

	// Widget setup.
	public function __construct() {

		// Widget settings.
		$widget_ops = array(
			'classname' => 'widget_alc_flickr',
			'description' => esc_html__('Display images from Flickr', 'express')
		);

		// Widget control settings.
		$control_ops = array(
			'id_base' => 'alc-flickr-widget'
		);

		// Create the widget.
		parent::__construct('alc-flickr-widget', esc_html__('Express - Flickr images', 'express') , $widget_ops, $control_ops);
	}

	// Display the widget on the screen.
	public function widget($args, $instance) {
		extract($args);
		$title = apply_filters('widget_title', $instance['title']);
		$id = $instance['flickr_id'];
		$nr = ($instance['flickr_nr'] != '') ? $nr = $instance['flickr_nr'] : $nr = 16;
		$randomId = mt_rand(0, 100000);
		echo $before_widget;
		if ($title) echo $before_title . $title . $after_title;
		echo "
		<script type=\"text/javascript\">
			jQuery(document).ready(function(){
				jQuery('.flickr-widget-$randomId').jflickrfeed({
					limit: ".$nr.",
					qstrings: {
						id: '".$id."'
					},
					itemTemplate: '<li><a href=\"http://www.flickr.com/photos/".$id."\" class=\"thumb-holder\" data-rel=\"prettyPhoto\"><img src=\"{{image_s}}\" alt=\"{{title}}\ width=\"75\" height=\"75\" /></a></li>'
				});
			});
		</script>";
		echo '<div class="flickr-widget"><ul id="basicuse" class="flickr-list flickr-widget-'.$randomId.'"></ul></div>'.$after_widget;
		
	}

	public function update($new_instance, $old_instance) {
		$instance = $old_instance;
		$instance['title'] = strip_tags($new_instance['title']);
		$instance['flickr_id'] = strip_tags($new_instance['flickr_id']);
		$instance['flickr_nr'] = strip_tags($new_instance['flickr_nr']);
		return $instance;
	}

	public function form($instance) {
		$defaults = array(
		'title' => 'Latest From Flickr',
		'flickr_nr' => '16',
		'flickr_id' => '47445714@N03'
		);
		
		$instance = wp_parse_args((array)$instance, $defaults); ?>
		<p>
			<label for="<?php echo $this->get_field_id('title'); ?>"><?php esc_html_e('Title:', 'express'); ?></label>
			<input id="<?php echo $this->get_field_id('title'); ?>" type="text" name="<?php echo $this->get_field_name('title'); ?>" value="<?php echo $instance['title']; ?>" class="widefat" />
		</p>
        
		<p>
			<label for="<?php echo $this->get_field_id('flickr_id'); ?>"><?php esc_html_e('Flickr ID:', 'express'); ?></label> 
			<input id="<?php echo $this->get_field_id('flickr_id'); ?>" type="text" name="<?php echo $this->get_field_name('flickr_id'); ?>" value="<?php echo $instance['flickr_id']; ?>" class="widefat" />
            <small style="line-height:12px;"><a href="http://www.idgettr.com">Find your Flickr user or group id</a></small>
		</p>
        <p>
			<label for="<?php echo $this->get_field_id('flickr_nr'); ?>"><?php esc_html_e('Number of photos:', 'express'); ?></label> 
			<input id="<?php echo $this->get_field_id('flickr_nr'); ?>" type="text" name="<?php echo $this->get_field_name('flickr_nr'); ?>" value="<?php echo $instance['flickr_nr']; ?>" class="widefat" />
		</p>
	<?php
	}
}

register_widget('alc_flickr_widget');

/* ***************************************************** 
 * Plugin Name: Express Last Works
 * Description: Retrieve and display latest works (Portfolio).
 * Version: 1.0
 * Author: Weblusive
 * Author URI: http://www.weblusive.com
 * ************************************************** */
class alc_works_widget extends WP_Widget {

	// Widget setup.
	public function __construct() {

		// Widget settings.
		$widget_ops = array(
			'classname' => 'widget_alc_works recentPostWidget',
			'description' => esc_html__('Display latest works (Portoflio)', 'express')
		);

		// Create the widget.
		parent::__construct('alc-works-widget', esc_html__('Express - Latest Works', 'express') , $widget_ops);
	}

	// Display the widget on the screen.
	public function widget($args, $instance) {
		extract($args);
		$title = apply_filters('widget_title', $instance['post_title']);
		
		echo $before_widget;
		if ($title) echo $before_title . $title . $after_title;
		$post_count = $instance['post_count'];
		//$position = $instance['position'];
		$featured = $instance['featured'];
		
		$args = array('post_type' => 'portfolio', 'taxonomy'=> 'portfolio_category', 'posts_per_page' => $post_count);
		if ($featured)
		{
			$args['meta_key'] = '_portfolio_featured'; 
			$args['meta_value'] = '1';
		}
		$loop = new WP_Query($args);?>
		
		<div class="recent_posts_wid alc_latestworks">
		<?php	while ( $loop->have_posts() ) : $loop->the_post();?>
			<div class="recent-content">
				<?php if(has_post_thumbnail()):?>
					<?php the_post_thumbnail('express-blog-thumb'); ?>
				<?php else: ?>
					
				<?php endif?>
				<h3><a href="<?php the_permalink()?>"><?php the_title();?></a></h3>
				<span><?php echo get_the_date('M d, Y'); ?></span>
			</div><!-- First post end-->

            <?php endwhile;?>
		</div>
		<?php echo $after_widget; 
	}

	public function update($new_instance, $old_instance) {
		$instance = $old_instance;
		$instance['post_title'] = strip_tags($new_instance['post_title']);
		$instance['post_count'] = strip_tags($new_instance['post_count']);
		//$instance['position'] = strip_tags($new_instance['position']);
		$instance['featured'] = strip_tags($new_instance['featured']);
		return $instance;
	}

	public function form($instance) {
		$defaults = array(
			'post_title' => 'Recent works',
			'post_count' => '3',
		//	'position'=>'',
			'featured' => '0',
		);
		$instance = wp_parse_args((array)$instance, $defaults); ?>
		<p>
			<label for="<?php echo $this->get_field_id('post_title'); ?>"><?php esc_html_e('Title', 'express'); ?></label>
			<input id="<?php echo $this->get_field_id('post_title'); ?>" type="text" name="<?php echo $this->get_field_name('post_title'); ?>" value="<?php echo $instance['post_title']; ?>" class="widefat" />
		</p>
        
         <p>
			<label for="<?php echo $this->get_field_id('featured'); ?>"><?php esc_html_e('Show only featured posts', 'express'); ?></label> 
			<select id="<?php echo $this->get_field_id('featured'); ?>" name="<?php echo $this->get_field_name('featured'); ?>" class="widefat">
				<option value="0" <?php if( $instance['featured'] == 0):?>selected="selected"<?php endif?>>No</option> 
				<option value="1" <?php if( $instance['featured'] == 1):?>selected="selected"<?php endif?>>Yes</option> 
			</select>
		</p>
        
        <p>
			<label for="<?php echo $this->get_field_id('post_count'); ?>"><?php esc_html_e('Number of Posts to show', 'express'); ?></label> 
			<input id="<?php echo $this->get_field_id('post_count'); ?>" type="text" name="<?php echo $this->get_field_name('post_count'); ?>" value="<?php echo $instance['post_count']; ?>" class="widefat" />
		</p>
		<!--
		<p>
			<label for="<?php //echo $this->get_field_id('position'); ?>"><?php// esc_html_e('Position', 'express'); ?></label> 
			<select id="<?php //echo $this->get_field_id('position'); ?>" name="<?php //echo $this->get_field_name('position'); ?>" class="widefat">
				<option value="sidebar" <?php //if( $instance['position'] == 'sidebar'):?>selected="selected"<?php //endif?>>Sidebar</option> 
				<option value="footer" <?php //if( $instance['position'] == 'footer'):?>selected="selected"<?php //endif?>>Footer</option> 
			</select>
		</p>
  -->
	<?php
	}
}

register_widget('alc_works_widget');



/* ***************************************************** 
 * Plugin Name: Express Blog Posts
 * Description: Retrieve and display latest blog posts.
 * Version: 1.0
 * Author: Weblusive
 * Author URI: http://www.weblusive.com
 * ************************************************** */
class alc_blogposts_widget extends WP_Widget {

	// Widget setup.
	public function __construct() {

		// Widget settings.
		$widget_ops = array(
			'classname' => 'widget_alc_blogposts recentPostWidget ',
			'description' => esc_html__('Display latest blog posts', 'express')
		);

		// Create the widget.
		parent::__construct('alc-blogposts-widget', esc_html__('Express Blog Posts', 'express') , $widget_ops);
	}

	// Display the widget on the screen.
	public function widget($args, $instance) {
		extract($args);
		$title = isset($instance['post_title']) ? apply_filters('widget_title', $instance['post_title']) : '';
		
		echo $before_widget;
		if ($title) echo $before_title . $title . $after_title;
		$post_count = isset($instance['post_count']) ? $instance['post_count'] : '2';
		//$show_date = isset($instance['show_date']) ? $instance['show_date'] : '';
		//$show_author = isset($instance['show_author']) ? $instance['show_author'] : '';
		$post_category = isset($instance['post_category']) ? $instance['post_category'] : '';
		$post_thumbs = isset($instance['post_thumbs']) ? $instance['post_thumbs'] : '';
		//$position = isset($instance['position']) ? $instance['position'] : '';
		
		
		global $post;
		$args = array( 'numberposts' => $post_count);
		if (!empty($post_category))
		$args['category'] = $post_category;
		$myposts = get_posts( $args );
		
		if ($myposts): ?>
		<div class="recent_posts_wid alc_latestworks">
				<?php  foreach( $myposts as $post ) :	setup_postdata($post);  ?> 
				<div class="recent-content <?php if($post_thumbs == 0):?>out-img<?php endif;?>">
					<?php if ($post_thumbs == 1):?>
						<?php if(has_post_thumbnail()):?>
							<?php the_post_thumbnail('express-blog-thumb'); ?>
						<?php else: ?>
							
						<?php endif?>
					<?php endif;?>
					<h3><a href="<?php the_permalink()?>"><?php the_title();?></a></h3>
					<span><?php echo get_the_date('M d, Y'); ?></span>
				</div><!-- First post end-->
				<?php endforeach; ?>
		</div>
		<?php endif;?>
        <?php echo $after_widget; 
	}

	public function update($new_instance, $old_instance) {
		$instance = $old_instance;
		$instance['post_title'] = $new_instance['post_title'];
		$instance['post_count'] = strip_tags($new_instance['post_count']);
		$instance['post_thumbs'] = strip_tags($new_instance['post_thumbs']);
		$instance['post_category'] = strip_tags($new_instance['post_category']);
		//$instance['show_date'] = strip_tags($new_instance['show_date']);
		//$instance['show_author'] = strip_tags($new_instance['show_author']);
		//$instance['position'] = strip_tags($new_instance['position']);
		
		return $instance;
	}

	public function form($instance) {
		$defaults = array(
			'post_title' => 'Latest from the blog',
			'post_count' => '2',
			'post_category' => '',
			'post_thumbs' => '',
			//'show_date' => '',
			//'show_author'=>'',
			//'position'=>''
		);
		$instance = wp_parse_args((array)$instance, $defaults); ?>
		<p>
			<label for="<?php echo $this->get_field_id('post_title'); ?>"><?php esc_html_e('Title', 'express'); ?></label>
			<input id="<?php echo $this->get_field_id('post_title'); ?>" type="text" name="<?php echo $this->get_field_name('post_title'); ?>" value="<?php echo $instance['post_title']; ?>" class="widefat" />
		</p>
        
        <p>
			<label for="<?php echo $this->get_field_id('post_count'); ?>"><?php esc_html_e('Number of Posts to show', 'express'); ?></label> 
			<input id="<?php echo $this->get_field_id('post_count'); ?>" type="text" name="<?php echo $this->get_field_name('post_count'); ?>" value="<?php echo $instance['post_count']; ?>" class="widefat" />
		</p>
        
         <p>
			<label for="<?php echo $this->get_field_id('post_category'); ?>"><?php esc_html_e('Category (Leave Blank to show from all categories)', 'express'); ?></label> 
			<input id="<?php echo $this->get_field_id('post_category'); ?>" type="text" name="<?php echo $this->get_field_name('post_category'); ?>" value="<?php echo $instance['post_category']; ?>" class="widefat" />
		</p>
		<p>
			<label for="<?php echo $this->get_field_id('post_thumbs'); ?>"><?php esc_html_e('Show thumbnails', 'express'); ?></label>
			<select id="<?php echo $this->get_field_id('post_thumbs'); ?>" name="<?php echo $this->get_field_name('post_thumbs'); ?>" class="widefat">
				<option value="0" <?php if( $instance['post_thumbs'] == 0):?>selected="selected"<?php endif?>>No</option> 
				<option value="1" <?php if( $instance['post_thumbs'] == 1):?>selected="selected"<?php endif?>>Yes</option> 
			</select>
		</p>
	<?php
	}
}

register_widget('alc_blogposts_widget');



/* ***************************************************** 
 * Plugin Name: 3-in-1 Posts
 * Description: Retrieve and display popular/latest posts/latest comments.
 * Version: 1.0
 * Author: Weblusive
 * Author URI: http://www.weblusive.com
 * ************************************************** */
class alc_totalposts_widget extends WP_Widget {

	// Widget setup.
	public function __construct() {

		// Widget settings.
		$widget_ops = array(
			'classname' => 'widget_alc_totalposts postTabWidget',
			'description' => esc_html__('Retrieve and display popular/latest posts.', 'express')
		);

		// Create the widget.
		parent::__construct('alc-totalposts-widget', esc_html__('Express Popular/Latest posts', 'express') , $widget_ops);
	}

	// Display the widget on the screen.
	public function widget($args, $instance) {
		extract($args);
		$title = apply_filters('widget_title', $instance['post_title']);
		
		echo $before_widget;
		if ($title) echo $before_title . $title . $after_title;
		$post_count = $instance['post_count'];
		$post_category = $instance['post_category'];
		
		global $post;
		$args = array( 'numberposts' => $post_count);
		if (!empty($post_category))
		$args['category'] = $post_category;
		?>
		<div class="tab-widget popular-latest-posts">
			<ul id="postTab" class="nav nav-tabs">
				<li class="active"><a href="#widget-popular" data-toggle="tab"><?php esc_html_e('Popular', 'express')?></a></li>
				<li><a href="#widget-recent" data-toggle="tab"><?php esc_html_e('Recent', 'express')?></a></li>
			</ul>
			<div id="tab-content" class="tab-content">
				<div id="widget-popular" class="tab-pane active">
					<div class="recent_posts_wid">
							<?php $myposts = get_posts( $args ); if ($myposts):?>
									<?php foreach( $myposts as $post ) :	setup_postdata($post);  ?>       
									<div class="recent-content">
										<?php if('' != get_the_post_thumbnail()):?>
											<?php the_post_thumbnail('express-blog-thumb' ); ?>
										<?php else: ?>
											
										<?php endif?>
										<h3><a href="<?php the_permalink()?>"><?php the_title();?></a></h3>
										<span><?php echo get_the_date('d M Y'); ?></span>
									</div>
									<?php endforeach;?>
							<?php endif; ?>
					</div>
				</div>
				
				<div id="widget-recent" class="tab-pane fade">
					<div class="recent_posts_wid">
							<?php  
							wp_reset_postdata();
							$args ['orderby'] = 'comment_count';
							$myposts = get_posts( $args );  
							if ($myposts):?>
									<?php foreach( $myposts as $post ) :	setup_postdata($post);  ?>  
									<div class="recent-content">
										<?php if('' != get_the_post_thumbnail()):?>
											<?php the_post_thumbnail('express-blog-thumb' ); ?>
										<?php else: ?>
											
										<?php endif?>
										<h3><a href="<?php the_permalink()?>"><?php the_title();?></a></h3>
										<span><?php echo get_the_date('d M Y'); ?></span>
									</div>
									<?php endforeach;?>
							<?php endif; ?>
					</div>
				</div>
			</div>
		</div>
        <?php echo $after_widget; 
	}

	public function update($new_instance, $old_instance) {
		$instance = $old_instance;
		$instance['post_title'] = strip_tags($new_instance['post_title']);
		$instance['post_count'] = strip_tags($new_instance['post_count']);
		$instance['post_category'] = strip_tags($new_instance['post_category']);
		return $instance;
	}

	public function form($instance) {
		$defaults = array(
			'post_title' => 'Blog posts',
			'post_count' => '3',
			'post_category' => ''
		);
		$instance = wp_parse_args((array)$instance, $defaults); ?>
		<p>
			<label for="<?php echo $this->get_field_id('post_title'); ?>"><?php esc_html_e('Title', 'express'); ?></label>
			<input id="<?php echo $this->get_field_id('post_title'); ?>" type="text" name="<?php echo $this->get_field_name('post_title'); ?>" value="<?php echo $instance['post_title']; ?>" class="widefat" />
		</p>
        
        <p>
			<label for="<?php echo $this->get_field_id('post_count'); ?>"><?php esc_html_e('Number of Posts to show', 'express'); ?></label> 
			<input id="<?php echo $this->get_field_id('post_count'); ?>" type="text" name="<?php echo $this->get_field_name('post_count'); ?>" value="<?php echo $instance['post_count']; ?>" class="widefat" />
		</p>
        
         <p>
			<label for="<?php echo $this->get_field_id('post_category'); ?>"><?php esc_html_e('Category (Leave Blank to show from all categories)', 'express'); ?></label> 
			<input id="<?php echo $this->get_field_id('post_category'); ?>" type="text" name="<?php echo $this->get_field_name('post_category'); ?>" value="<?php echo $instance['post_category']; ?>" class="widefat" />
		</p>
	<?php
	}
}

register_widget('alc_totalposts_widget');


/* ***************************************************** 
 * Plugin Name: Express Contact Widget
 * Description: Display contact widget on footer.
 * Version: 1.0
 * Author: Weblusive
 * Author URI: http://www.weblusive.com
 * ************************************************** */
/**
 * Contact Form Widget Class
 */
class alc_Contact_Form extends WP_Widget {
	
	public function __construct() {
		$widget_ops = array('classname' => 'alc_contact_form_entries', 'description' => esc_html__("Contact widget", 'express') );
		parent::__construct('alc_Contact_Form', esc_html__('Express - Contact Form', 'express'), $widget_ops);
	}

	public function widget($args, $instance) {
		extract($args);
		$title = apply_filters('widget_title', empty($instance['title']) ? esc_html__('Contact Us', 'express') : $instance['title'], $instance);
		$email = apply_filters('widget_title', empty($instance['email']) ? '' : $instance['email'], $instance);
		$success = apply_filters('widget_title', empty($instance['success']) ? esc_html__('Thank you, e-mail sent.', 'express') : $instance['success'], $instance);
		
		echo $before_widget;
		
		if ( $title ) echo $before_title . $title . $after_title;
        ?>                
			<form action="#" method="post" id="contactFormWidget">
				<div class="contact-widget-wrapper">
					<div class="row">
						<div class="col-sm-6">
							<input type="text" name="wname" id="wname" value=""  placeholder="<?php esc_html_e('Name', 'express')?>"/>
						</div>
						<div class="col-sm-6">
							<input type="text" name="wemail" id="wemail" value=""  placeholder="<?php esc_html_e('Email', 'express')?>" />
						</div>
					</div>
                    <div class="row">	
						<div class="col-sm-12">
							<textarea name="wmessage" id="wmessage"  placeholder="<?php esc_html_e('Message', 'express')?>"></textarea>
							<input type="submit" id="wformsend" value="<?php esc_html_e('Send', 'express')?>" class="button" name="wsend" />
						</div>
					</div>
					<div class="loading"></div>
					<div>
						<input type="hidden" name="wcontactemail" id="wcontactemail" value="<?php echo $email?>" />
						<input type="hidden" value="<?php echo esc_url(home_url('/'))?>" id="wcontactwebsite" name="wcontactwebsite" />
						<input type="hidden" name="wcontacturl" id="wcontacturl" value="<?php echo get_template_directory_uri()?>/library/sendmail.php" />
					</div>
				</div>
				<div class="clearfix"></div>
				<div class="widgeterror"></div>
				<div class="widgetinfo"><i class="fa fa-envelope"></i><?php echo $success?></div>
			</form>
		<?php
		echo $after_widget;
	}

	public function update( $new_instance, $old_instance ) {
		$instance = $old_instance;
		$instance['title'] = strip_tags($new_instance['title']);
		$instance['email'] = strip_tags($new_instance['email']);
		$instance['success'] = strip_tags($new_instance['success']);
		return $instance;
	}

	public function form( $instance ) {
		$title = isset($instance['title']) ? esc_attr($instance['title']) : '';
		$email = isset($instance['email']) ? esc_attr($instance['email']) : '';
		$success = isset($instance['success']) ? esc_attr($instance['success']) : '';
	?>
	
		<div>
        	<label for="<?php echo $this->get_field_id('title'); ?>"><?php esc_html_e('Title:<br />', 'express'); ?>
			<input class="widefat" id="<?php echo $this->get_field_id('title'); ?>" name="<?php echo $this->get_field_name('title'); ?>" type="text" value="<?php echo $title; ?>" /></label></p>
		</div>
        <div>
        	<label for="<?php echo $this->get_field_id('email'); ?>"><?php esc_html_e('Email Address:<br />', 'express'); ?>
			<input class="widefat" id="<?php echo $this->get_field_id('email'); ?>" name="<?php echo $this->get_field_name('email'); ?>" type="text" value="<?php echo $email; ?>" /></label></p>
		</div>
        <div>
        	<label for="<?php echo $this->get_field_id('success'); ?>"><?php esc_html_e('Success Message:<br />', 'express'); ?>
			<input class="widefat" id="<?php echo $this->get_field_id('success'); ?>" name="<?php echo $this->get_field_name('success'); ?>" type="text" value="<?php echo $success; ?>" /></label></p>
		</div>
		<div style="clear:both"></div>
<?php
	}
}

register_widget('alc_Contact_Form');
?>