<?php /** The template for displaying Archive pages. **/
get_header();
$sidebar = weblusive_get_option('sidebar_archive');
$search_refer = isset($_GET["post_type"]) ? $_GET["post_type"] : 'post';
$weblusive_sidebar_pos =  weblusive_get_option('sidebar_pos');
if (empty ($sidebar)) $weblusive_sidebar_pos = 'full';

$bgimage=weblusive_get_option('innerheading_background_image');
if($bgimage) {
	$bgimg=$bgimage;
}else{
	$bgimg=get_template_directory_uri() .'/images/about-banner.jpg' ;
}
?>
<?php if(!((weblusive_get_option('hide_titles') && weblusive_get_option('hide_breadcrumbs')))):?>
<div id="page-banner" class="page-banner container-fluid no-padding" style="background: url(<?php echo esc_url($bgimg);?>) no-repeat center center / cover #000000;">
	<div class="banner-content">
		<?php if (!weblusive_get_option('hide_titles')):?>
				<h3><?php printf( esc_html__('Search Results for: %s', 'express' ), '<mark>' . get_search_query() . '</mark>' ); ?></h3>
		<?php endif; ?>
		<?php if (!weblusive_get_option('hide_breadcrumbs')):?>
			<?php if(class_exists('the_breadcrumb')){ $albc = new the_breadcrumb; } ?>
		<?php endif; ?>
	</div>
</div>
<?php endif; ?>
<div class="blog-section blog-list container-fluid no-padding">
	<div class="section-padding"></div>
	<div class="container">
		<div class="row">
			<?php if ($weblusive_sidebar_pos == 'left'):?>
				<div class="widget-area col-md-4 col-sm-4 sidebar-left"><?php get_sidebar($sidebar); ?></div>
			<?php endif ?>
			<div class="<?php if ($weblusive_sidebar_pos == 'full' || empty($sidebar)):?>col-md-12<?php else:?>col-md-8 col-sm-8<?php endif?> content-area">
				<?php $args = array('post_type'=> $search_refer, 's' => $s, 'paged' => $paged); query_posts($args);
				if ( have_posts() ) : ?>
					<?php get_template_part( 'loop', 'search' );?>
				<?php else : ?>
					<div id="post-0" class="blog-post no-results not-found">
						<div class="post-content">
							<h4><?php esc_html_e('Nothing Found', 'express' ); ?></h4>
							<div class="entry-content">
								<p><?php esc_html_e('Sorry, but nothing matched your search criteria. Please try again with some different keywords.', 'express' ); ?></p>
							</div><!-- .entry-content -->
						</div>
					</div><!-- #post-0 -->
				<?php endif; ?>
				<?php if ( $wp_query->max_num_pages > 1 ): ?>
					<div class="row">
						<div class="col-md-12 col-sm-12">
							<div class="pagination_number">
								<nav class="content-center margin-top-70">
								  <?php include(express_plugins . '/wp-pagenavi.php' ); wp_pagenavi(); ?>
								</nav>
							</div>
						</div>
					</div>
				<?php endif?>
			</div>
			<?php if ($weblusive_sidebar_pos == 'right'):?>
				<div class="widget-area col-md-4 col-sm-4 sidebar" ><?php get_sidebar($sidebar); ?></div>
			<?php endif ?>
		</div>
	</div>
	<div class="section-padding"></div>
</div>
<?php get_footer(); ?>