<?php /** The Template for displaying all single posts. **/

get_header(); 
$get_meta = get_post_custom($post->ID);

$overridepos = isset($get_meta['_weblusive_sidebar_pos']) ? $get_meta['_weblusive_sidebar_pos'] : array (0 => 'full');
$overridesidebar =isset($get_meta['_weblusive_sidebar_post']) ? $get_meta['_weblusive_sidebar_post'] : array (0 => '');

$sidebarPos = ($overridepos[0] == 'default') ?  weblusive_get_option('sidebar_pos') : $overridepos[0];
$sidebar = ($overridesidebar[0] == '') ?  weblusive_get_option('sidebar_post') : $overridesidebar[0];
$nocomments = weblusive_get_option('blog_disable_comments');
$notags = weblusive_get_option('blog_disable_tags');

$showauthor =weblusive_get_option('blog_show_author') ; 
$noshare = weblusive_get_option('blog_disable_share');
$nobio = weblusive_get_option('blog_enable_authorbio');
$day = get_the_time('d'); $month = get_the_time('M'); $year = get_the_time('Y');
$format =  get_post_format( $post->ID );
if (empty($format)) $format = 'standard';
switch ($format) {
	case 'image':
		$formatIcon="icon_camera_alt";
	break;
	case 'link':
		$formatIcon="icon_link_alt";
	break;
	case 'audio':
		$formatIcon="icon_music";
	break;
	case 'status':
		$formatIcon="icon_comment_alt";
	break;
	case 'quote':
		$formatIcon="icon_quotations";
	break;
	case 'video':
		$formatIcon="icon_film";
	break;
	case 'gallery':
		$formatIcon="icon_images";
	break;
	default:
		$formatIcon="icon_document_alt";
	break;
}

	
//get_template_part( 'library/includes/page-head' );
get_template_part( 'inner-header', 'content');
?>
<div class="blog-section single-blog container-fluid no-padding">
	<div class="section-padding"></div>
	<div class="container">
		<div class="row">
			<?php if (!empty($sidebar) && $sidebarPos=='left') :?>
				<div class="widget-area col-md-4 col-sm-4 sidebar-left"><?php dynamic_sidebar($sidebar);?></div>
			<?php endif ?>
			<?php if ( have_posts() ) while ( have_posts() ) : the_post(); ?>
				<div class="<?php if (empty($sidebar) || $sidebarPos == 'full'):?>col-md-12<?php else:?>col-md-8 col-sm-8<?php endif?> content-area">
					<article class="single_post margin-bottom-50 single-post <?php echo $format?>">
						<div class="entry-cover">
							<?php 
							   $get_meta = get_post_custom($post->ID);
							   $mediatype = isset($get_meta["_blog_mediatype"]) ? $get_meta["_blog_mediatype"][0] : 'image';
							   $videoId = isset($get_meta["_blog_video"]) ? $get_meta["_blog_video"][0] : ''; 
							   $autoplay =  isset($get_meta["_blog_videoap"]) ? $get_meta["_blog_videoap"][0] : '0';
							   $thumbnail = get_the_post_thumbnail($post->ID, 'express-blog-list-1');
						    ?>                   
							<?php if ($format == 'standard' || $format == 'video' || $format == 'image' || $format == 'gallery'):?>   
							<?php if($format == 'standard' || $format == 'image'):
								$noimage = (isset($get_meta['_weblusive_post_head'][0]) && $get_meta['_weblusive_post_head'][0] == 'none') ? true : false;
							?>
								<?php $thumbnail = get_the_post_thumbnail(); if(!empty($thumbnail)) : ?>
									<?php the_post_thumbnail('express-blog-list-1', array("class"=>"img-responsive blog-post-img")); ?>
								<?php endif?>
							<?php elseif ($format == 'video'):
								global $wp_embed;
								$post_embed = '';
								$video = isset($get_meta["_blog_video"]) ? $get_meta["_blog_video"][0] : ''; 
								$videoself = isset($get_meta["_blog_video_selfhosted"]) ? $get_meta["_blog_video_selfhosted"][0] : ''; 
								if ($video || $videoself): ?>
									<div class="flex-video">
										<?php
											if ($video):
												$post_embed = $wp_embed->run_shortcode('[embed width="750" height="366"]'.$video.'[/embed]'); 
											else:
												$post_embed = $wp_embed->run_shortcode($videoself);
											endif;
											echo $post_embed; 
										?>
									</div>	
								<?php else:?>
									<div class="alert alert-danger fade in">
										<?php esc_html_e('Video post format was chosen but no url or embed code provided. Please fix this by providing it.', 'express') ?>
									</div>
								
								<?php endif?>
							<?php elseif ($format == 'gallery'):
								$full_image = wp_get_attachment_image_src(get_post_thumbnail_id($post->ID), 'full', false); 
								$argsThumb = array(
									'order'          => 'ASC',
									'posts_per_page'  => 99,
									'post_type'      => 'attachment',
									'post_parent'    => $post->ID,
									'post_mime_type' => 'image',
									'post_status'    => null,
									//'exclude' => get_post_thumbnail_id()
								);
								?>
								<div class="flexpost flexslider">
									<ul class="slides">
									<?php 
										$attachments = get_posts($argsThumb);
										if ($attachments) {
											foreach ($attachments as $attachment) {
												$image = wp_get_attachment_url($attachment->ID, 'full', false, false);
												$alt = $attachment->post_excerpt;
												echo '<li><img src="'.$image.'" alt="'.$alt.'" class="img-responsive blog-post-img"></li>';
											}
										}
									?>
									</ul>
								</div>
							<?php endif?>
							<?php else :?>
								<img src="http://placehold.it/750x366" alt="no-image"/>
							<?php endif; ?>
							<div class="post-meta"><i class="<?php echo $formatIcon; ?>"></i></div>
						</div>
						<div class="entry-header">
							<div class="entry-title">
								<h3><?php the_title()?></h3>
								<?php $meta = express_meta($post); echo $meta ?>
							</div>
						</div>
						<div class="entry-content">
							<?php the_content()?>
							<?php wp_link_pages( array( 'before' => '<div class="page-link">' . esc_html__('Pages:', 'express' ), 'after' => '</div>' ) ); ?>
						</div>
						<div class="tags">
							<?php if (!$notags): $posttags = get_the_tags();?>
								<?php if($posttags):?>			
									<div class="col-md-8 no-padding">

										<a title="Tags"><?php esc_html_e('Tags:', 'express') ?></a>
										<?php foreach($posttags as $tag):?>
											<a href="<?php echo  get_tag_link($tag->term_id)?>"><?php echo $tag->name?><span class="tag-divider">,</span></a>
										<?php endforeach?>
									</div>
								<?php endif?>
							<?php endif?>
							<div class=" col-md-4 pull-right">
								<div class="post-navigation">
									<?php				
									$prev_post = get_previous_post();
									if (!empty( $prev_post )): ?>
										<a href="<?php echo get_permalink( $prev_post->ID ); ?>" class="post-prev"><?php esc_html_e('Older Post', 'express') ?></a>
									<?php endif; ?>
									<?php $next_post = get_next_post();
									if (!empty( $next_post )): ?>
										<a href="<?php echo get_permalink( $next_post->ID ); ?>" lass="post-next"><?php esc_html_e('Next Post', 'express') ?></a>
									<?php endif; ?>
								</div>
							</div>
						</div>
					</article> 
							<!-- author box -->
							<?php if ($nobio):?>
								<?php 
									$photo2 = get_avatar( get_the_author_meta('email'), 150);
									$bio = get_the_author_meta('description');
									$website = get_the_author_meta('user_url');
									$name= get_the_author_meta('first_name');
									$lastName=get_the_author_meta('last_name');

								?>
								<div class="about-author">
									<div class="author-intro">
										<?php echo $photo2; ?>
										<?php echo $name.' '.$lastName; ?>
										<p><?php echo $bio?></p>
									</div>
								</div>            
							<?php endif?>
							<?php if (!$nocomments):?>
								<div class="post-comment">
									<?php if( 'open' == $post->comment_status) comments_template(); ?>
									<?php $test = false; if ($test) {comment_form();} ?>
								</div>
							<?php endif; ?>
							
				</div>
			<?php endwhile; ?>
			<?php if (!empty($sidebar) && $sidebarPos=='right') :?>
				<div class="widget-area col-md-4 col-sm-4 sidebar" ><?php dynamic_sidebar($sidebar);?></div>
			<?php endif ?>
		</div>
	</div>
	<div class="section-padding"></div>
</div>
<?php get_footer(); ?>