<?php /* Template Name: Under Construction */ ?>

<?php get_header();
if (weblusive_get_option('uc_launchdate')):
   $date = explode('/', weblusive_get_option('uc_launchdate'));
	?>
	<script type="text/javascript">
		jQuery(document).ready(function(){ 			
			jQuery('div.clock').countdown("<?php echo esc_attr($date[0])?>/<?php echo esc_attr($date[1])?>/<?php echo esc_attr($date[2])?>", function(event) {
				var $this = jQuery(this);
				switch(event.type) {
					case "seconds":
					case "minutes":
					case "hours":
					case "days":
					case "weeks":
					case "daysLeft":
						$this.find('span#'+event.type).html(event.value);
					break;
					case "finished":
					$this.hide();
						break;
				}
			});
		}); 
	</script> 
	<?php 
endif;
?>

<?php
	$get_meta = get_post_custom($post->ID);
	$title = get_the_title($post->ID);
	$alternativetitle = isset( $get_meta['_weblusive_altpagetitle'][0]) ? $get_meta["_weblusive_altpagetitle"][0] : '';
	$weblusive_sidebar_pos = isset( $get_meta['_weblusive_sidebar_pos'][0]) ? $get_meta["_weblusive_sidebar_pos"][0] : 'full';
	get_template_part( 'library/includes/page-head' ); 

?>
	<section class="coming-soon container-fluid no-padding">
		<?php if ( have_posts() ) while ( have_posts() ) : the_post(); ?>
		<div class="section-header">
			<h3><?php echo ($alternativetitle == '') ?  $title : $alternativetitle; ?></h3>
			<?php if(weblusive_get_option( 'uc_maintitle' )):?>
				<p class="uc-text"><?php echo weblusive_get_option( 'uc_maintitle' ) ?></hp>
			<?php endif?>
		</div>
		<div class="container">
			<div class="section-padding"></div>
			<div class="row clock">
				<div class="col-md-2"><span id="weeks"></span><?php esc_html_e('Weeks', 'express')?></div>
				<div class="col-md-2"><span id="daysLeft"></span><?php esc_html_e('Days', 'express')?></div>
				<div class="col-md-2"><span id="hours"></span><?php esc_html_e('Hours', 'express')?></div>
				<div class="col-md-2"><span id="minutes"></span><?php esc_html_e('Minutes', 'express')?></div>
				<div class="col-md-2"><span id="seconds"></span><?php esc_html_e('Seconds', 'express')?></div>
			</div>
			<div class="section-padding"></div>
			<!-- Notification -->
			<?php $newsletter = weblusive_get_option( 'uc_enable_newsletter' ); if($newsletter):?>
				<div class="notification col-md-12">
					<?php echo do_shortcode('[email-newsletter-plugin]')?>
				</div>
			<?php endif?>
			<!-- Notification /- -->
			<div class="col-md-12"><?php the_content(); ?></div>
		</div>
		<?php endwhile; ?>	
		<div class="section-padding"></div>
	</section>
<?php get_footer();?>